/****
 * CListingPane.cp
 *
 *	A text pane for the source listing.  It doesn't allow editing,
 *  nor selecting.  It highlights the current error...
 *
 ****/
/*
 * Copyright (C) 1985-1992  New York University
 * Copyright (C) 1994 George Washington University
 * 
 * This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
 * system.  See the Ada/Ed README file for warranty (none) and distribution
 * info and also the GNU General Public License for more details.
 */



#include "CListingPane.h"
#include <LongQD.h>
#include "AppCommands.h"
#include <CBartender.h>

extern	CBartender	*gBartender;	/* The menu handling object */

#ifdef useCPEdit
long PEWordBreaker(long charPos, BreakDirection direction, CPEditText *thePEditText);

static long PEWordBreaker(long charPos, BreakDirection direction,
	CPEditText *thePEditText)
{
}

#else

static pascal Boolean myLineBreaker(Ptr textPtr, short offset );

static pascal Boolean myLineBreaker(Ptr textPtr, short offset )
{
char ch;

	ch = textPtr[offset];

	/* return TRUE if ch is a break character */

	if ((ch == '\n') || (ch == '\r'))
		return( TRUE );
	else
		return( FALSE );
}

#endif



void	CListingPane::IListingPane(CView *anEnclosure,
	CBureaucrat		*aSupervisor,
	short			aWidth,
	short			aHeight,
	short			aHEncl,
	short			aVEncl,
	SizingOption	aHSizing,
	SizingOption	aVSizing)
{
	inherited::ITextPane(anEnclosure, aSupervisor,
		aWidth, aHeight, aHEncl, aVEncl, aHSizing, aVSizing);
	itsLine1 = itsLine2 = -1;

	fVOrigin = vOrigin;
}

void	CListingPane::HilightLines(short line1, short line2)
{
	long start, end;

#ifdef useCPEdit

	start = GetLineStart(line1);
	end = GetLineEnd(line2);

#else
	TEHandle te;

	itsLine1 = line1;
	itsLine2 = line2;

	if (itsLine1 < 0 || itsLine2 < 0)
		return;


	te = this->macTE;
	if (itsLine1 < (*te)->nLines)
		start = (*te)->lineStarts[itsLine1];
	else
		start = (*te)->teLength;

	if (itsLine2 < (*te)->nLines)
		end = (*te)->lineStarts[itsLine2];
	else
		end = (*te)->teLength;
#endif

	SetSelection(start, end, kRedraw);
}

void	CListingPane::SetTEWordBreak(void)
{
#ifdef useCPEdit
	//SetWordBreakHook(PEWordBreaker);
#else
	SetWordBreak(myLineBreaker, macTE);
#endif
}

/******************************************************************************
 PrepareToPrint

		Set up coordinate system and clipping region for printing. This
		method prepares the port so that only the portion of the pane
		which is visible on the screen is printed.
 ******************************************************************************/

void	CListingPane::PrepareToPrint( void)
{
	Rect		clipR;
	LongRect 	lr;

	if ((!usingLongCoord) && (printClip == clipPAGE)) {
		SetOrigin((short) hOrigin, (short) vOrigin - fVOrigin);
		clipR = cPageArea;
		WindToFrameR( &clipR, &lr);
		LongToQDRect( &lr, &clipR);
		ClipRect(&clipR);
	}
	else
		inherited::PrepareToPrint();
	
}
